/**********************************************************************
 *<
	FILE: main.cpp

	DESCRIPTION:   Calculates surface area of the object

	CREATED BY: Andrey Zmievski

	HISTORY: created 1 March 97

 *>	Copyright (c) 1997, All Rights Reserved.
 **********************************************************************/

#include "Area.h"

HINSTANCE hInstance;
static BOOL controlsInit = FALSE;

/** public functions **/
BOOL WINAPI DllMain(HINSTANCE hinstDLL,ULONG fdwReason,LPVOID lpvReserved) {
	hInstance = hinstDLL;

	if (!controlsInit) {
		controlsInit = TRUE;
		
		// jaguar controls
		InitCustomControls(hInstance);
		
		// initialize Chicago controls
		InitCommonControls();
		}
			
	return (TRUE);
	}


//------------------------------------------------------
// This is the interface to Jaguar:
//------------------------------------------------------

__declspec( dllexport ) const TCHAR *
LibDescription() { return _T("Map Collection Utility"); }

/// MUST CHANGE THIS NUMBER WHEN ADD NEW CLASS
__declspec( dllexport ) int LibNumberClasses() {
	return 1;
}


__declspec( dllexport ) ClassDesc*
LibClassDesc(int i) {
	switch(i) {
		case 0: return GetAreaDesc();
		default: return 0;
		}
			
	}

// Return version so can detect obsolete DLLs
__declspec( dllexport ) ULONG 
LibVersion() { return VERSION_3DSMAX; }

TCHAR *GetString(int id)
	{
	static TCHAR buf[256];

	if (hInstance)
		return LoadString(hInstance, id, buf, sizeof(buf)) ? buf : NULL;
	return NULL;
	}
